<?php
function facebook_clone_enqueue_styles() {
    wp_enqueue_style('facebook-final-style', get_stylesheet_uri());
}
add_action('wp_enqueue_scripts', 'facebook_clone_enqueue_styles');

function facebook_clone_setup() {
    register_nav_menu('primary', __('Principal', 'facebook-clone-final'));
    add_theme_support('post-thumbnails');
    if (function_exists('buddypress')) {
        add_theme_support('buddypress');
    }
}
add_action('after_setup_theme', 'facebook_clone_setup');

function facebook_clone_widgets_init() {
    register_sidebar(array(
        'name'          => __('Barra Lateral Esquerda', 'facebook-clone-final'),
        'id'            => 'sidebar-left',
        'before_widget' => '<div class="widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
    register_sidebar(array(
        'name'          => __('Barra Lateral Direita', 'facebook-clone-final'),
        'id'            => 'sidebar-right',
        'before_widget' => '<div class="widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
}
add_action('widgets_init', 'facebook_clone_widgets_init');
?>