<?php
function tiktok_clone_enqueue_styles() {
    wp_enqueue_style('tiktok-style', get_stylesheet_uri());
}
add_action('wp_enqueue_scripts', 'tiktok_clone_enqueue_styles');

function tiktok_clone_setup() {
    register_nav_menu('primary', __('Principal', 'tiktok-clone-responsive'));
    add_theme_support('post-thumbnails');
    if (function_exists('buddypress')) {
        add_theme_support('buddypress');
    }
}
add_action('after_setup_theme', 'tiktok_clone_setup');

function tiktok_clone_widgets_init() {
    register_sidebar(array(
        'name'          => __('Barra Lateral', 'tiktok-clone-responsive'),
        'id'            => 'sidebar-1',
        'before_widget' => '<div class="widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
}
add_action('widgets_init', 'tiktok_clone_widgets_init');
?>