<?php get_header(); ?>
<?php if ( have_posts() ) : ?>
  <div class="main-content">
    <?php while ( have_posts() ) : the_post(); ?>
      <article class="post">
        <div class="post-video">
          <?php if ( has_post_thumbnail() ) : ?>
            <?php the_post_thumbnail('large'); ?>
          <?php else : ?>
            <img src="<?php echo get_template_directory_uri(); ?>/placeholder-video.png" alt="Vídeo">
          <?php endif; ?>
        </div>
        <div class="post-info">
          <span class="author"><?php the_author(); ?></span>
          <p class="description"><?php the_excerpt(); ?></p>
        </div>
      </article>
    <?php endwhile; ?>
  </div>
  <aside class="sidebar">
    <?php if ( is_active_sidebar('sidebar-1') ) : dynamic_sidebar('sidebar-1'); endif; ?>
  </aside>
<?php else : ?>
  <p><?php esc_html_e('Nenhuma publicação encontrada.', 'tiktok-clone-responsive'); ?></p>
<?php endif; ?>
<?php get_footer(); ?>